///////////////////////////////////////////////////////////
//		PATHS.WDL          
//
//    Copyright 2004 Sean Patrick Hannifin
//		Created for 3DGS Isometric Tutorial
//		Version 1.00  -  September 2004
//
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
// Global variables

// Contains the nodes that are 'open'
var OpenList[400];
// Contains the order in which to move through the nodes
var MoveList[400];
// Stores the numerical value of each node
var NodeValues[400];

// Stores the current node, of course!
var CurrentNode = 0;
var BestNode = 0;
var OpenNodes = 0;

entity* tester;

///////////////////////////////////////////////////////////
// Functions

// This function sets all the OpenList array members to 0
function InitOpenList()
{
	var num = 0;
	
	while (num < (GridLength * GridWidth))
	{
		OpenList[num] = -1;
		num += 1;
	}
}

// This function sets all the MoveList array members to 0
function InitMoveList()
{
	var num = 0;
	
	while (num < (GridLength * GridWidth))
	{
		MoveList[num] = -1;
		num += 1;
	}
}

function AddToMoveList(num)
{
	var loop = 0;
	
	while (loop < (GridLength * GridWidth))
	{
		if (MoveList[loop] == -1)
		{
			MoveList[loop] = num;
			break;
		}		
		loop += 1;
	}
}

function TakeFromMoveList(num)
{
	var loop;
	loop = (GridLength * GridWidth) - 1;
	
	while (loop > -1)
	{
		if (MoveList[loop] == num)
		{
			MoveList[loop] = -1;
			break;
		}
		loop -= 1;
	}
}

function FindLastMove()
{
	var loop;
	loop = (GridLength * GridWidth) - 1;
	
	while (loop > -1)
	{
		if (MoveList[loop] != -1)
		{
			CurrentNode = MoveList[loop];
			break;
		}		
		loop -= 1;
	}
}

// This value goes through each node and gives it a value
// based on its distance from the goal node
function CalcValues(goal)
{
	var num = 0;
	var tempx;
	var tempy;
	
	var goalx;
	var goaly;
	
	while (num < (GridLength * GridWidth))
	{
		if (Nodes[num] == 1)
		{
			tempx = int(num / GridLength);
			tempy = num - (tempx * GridWidth);
			
			goalx = int(goal / GridLength);
			goaly = goal - (goalx * GridWidth);
		
			NodeValues[num] = sqrt(pow((goalx - tempx),2)+pow((goaly - tempy),2));
			
			OpenList[num] = 1;
		}
		
		num += 1;
	}
}

///////////////////////////////////////////////////////////

function LookAround()
{	
	OpenNodes = 0;
	
	BestNode = CurrentNode;
	
	// Check Nodes
	if (((CurrentNode + GridLength) < (GridLength * GridWidth)) && ((CurrentNode + GridLength) > -1))
	{
		if (OpenList[CurrentNode + GridLength] == 1)
		{
			OpenNodes += 1;
			BestNode = (CurrentNode + GridLength);
			beep();
		}
	}
	if (((CurrentNode - GridLength) < (GridLength * GridWidth)) && ((CurrentNode - GridLength) > -1))
	{	if (OpenList[CurrentNode - GridLength] == 1)
		{
			OpenNodes += 1;
			if (NodeValues[BestNode] > NodeValues[CurrentNode - GridLength])
			{
				BestNode = CurrentNode - GridLength;
				beep();
			}
			if (BestNode == CurrentNode)
			{
				BestNode = CurrentNode - GridLength;
				beep();
			}
		}
	}
	if (((CurrentNode + 1) < (GridLength * GridWidth)) && ((CurrentNode + 1) > -1))
	{	if (OpenList[CurrentNode + 1] == 1)
		{
			OpenNodes += 1;
			if (NodeValues[BestNode] > NodeValues[CurrentNode + 1])
			{
				BestNode = CurrentNode + 1;
				beep();
			}
			if (BestNode == CurrentNode)
			{
				BestNode = CurrentNode + 1;
				beep();
			}
		}
	}
	if (((CurrentNode - 1) < (GridLength * GridWidth)) && ((CurrentNode - 1) > -1))
	{	if (OpenList[CurrentNode - 1] == 1)
		{
			OpenNodes += 1;
			if (NodeValues[BestNode] > NodeValues[CurrentNode - 1])
			{
				BestNode = CurrentNode - 1;
				beep();
			}
			if (BestNode == CurrentNode)
			{
				BestNode = CurrentNode - 1;
				beep();
			}
		}
	}
}

///////////////////////////////////////////////////////////
// The main pathfinding function

function PathFind(start, goal)
{
	InitOpenList();
	InitMoveList();
	
	CalcValues(goal);
	
	wait(100);
	
	CurrentNode = start;
	
	while (CurrentNode != goal)
	{
		LookAround();
		if (OpenNodes == 0)
		{
			if (CurrentNode == start)
			{
				break;
			}
			
			OpenList[CurrentNode] = -1;
			FindLastMove();
			TakeFromMoveList(CurrentNode);
		}
		if (OpenNodes > 0)
		{
			OpenList[CurrentNode] = -1;
			AddToMoveList(CurrentNode);
			CurrentNode = BestNode;
		}
		
		if (CurrentNode == goal)
		{
			beep();
			AddToMoveList(CurrentNode);
			break;
		}
		wait(1);
	}
}


action IMTester
{
	tester = me;
	my.z = 10;
}


function MoveIt(start, goal)
{
	var tempx;
	var tempy;
	
	var loop = 0;
	
	var MyNode;
	var MoveTo;
	
	MyNode = start;
	
	tempx = int(start / GridLength);
	tempy = start - (tempx * GridLength);
	
	tempx = (tempx * TileSize) - ((GridLength / 2) * TileSize - (TileSize / 2));
	tempy = (tempy * TileSize) - ((GridLength / 2) * TileSize - (TileSize / 2));
	
	tester.x = tempx;
	tester.y = tempy;
	
	while ((loop < (GridLength * GridWidth)) && (MyNode != goal))
	{
		wait(32);
		
		if (MoveList[loop] != -1)
		{
			MoveTo = MoveList[loop];
		}
		
		tempx = int(MoveTo / GridLength);
		tempy = MoveTo - (tempx * GridLength);
		
		tempx = (tempx * TileSize) - ((GridLength / 2) * TileSize - (TileSize / 2));
		tempy = (tempy * TileSize) - ((GridLength / 2) * TileSize - (TileSize / 2));
		
		tester.x = tempx;
		tester.y = tempy;
		
		MyNode = MoveTo;
		
		loop += 1;
		wait(1);
	}	
}

function test()
{
	PathFind(0,2);
}

function test2()
{
	MoveIt(0,2);
}

on_q = test();
on_w = test2();